//=============================================================================
// ExtraCritical_CriticalFlavorText.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2022/07/17 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 多段クリティカル機構追加機能_クリティカルフレーバーテキスト
 * @target MZ
 * @author くろあめ
 *
 * @help
 * アクターがスキルを使用する際に、スキル使用時メッセージの二行目を
 * 第二クリティカル以上のクリティカルが出た際にのみログに表示することで
 * スキル使用時メッセージの二行目を、クリティカル時のフレーバーテキストとして運用します。
 * 
 * このプラグインを導入すると、第二クリティカル以上のクリティカルが出ない限り
 * スキル使用時メッセージの二行目はログに描画されません
 * クリティカル無しのスキルや、ダメージの無いスキルでは
 * 事実上、スキル使用時メッセージの二行目が封印されます
 * これを踏まえて、導入するかどうかを検討してください。
 *
 * 尚、エネミーのスキル使用時のログ出力には一切干渉しません
 * エネミーがスキルを使用する際には、スキル使用時メッセージの二行目は
 * デフォルトと同じように、無条件でバトルログに出力されます。
 *
 * このプラグインは、多段クリティカル機構プラグイン
 * 「ExtraCritical.js」に機能追加を行うプラグインです
 * 動作には本体である「ExtraCritical.js」導入が前提となります
 * 必ず「ExtraCritical.js」より下に導入してください。
 *
 * このプラグインは、戦闘で使われる各種関数を再定義する都合上
 * 非常に競合性の高い作りになっています
 * ほかの戦闘計算式系スクリプトと共存させるときには
 * 細心の注意を払ってください。
 *
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */

(function() {


Window_BattleLog.prototype.displayAction = function(subject, item) {
    const numMethods = this._methods.length;
    if (DataManager.isSkill(item)) {
        if(subject.isActor()){
            this.displayItemMessage(item.message1, subject, item);
        }
        else{
            this.displayItemMessage(item.message1, subject, item);
            this.displayItemMessage(item.message2, subject, item);
        }
    } else {
        this.displayItemUseMessage(TextManager.useItem, subject, item);
    }
    if (this._methods.length === numMethods) {
        this.push("wait");
    }
};


/* 都合上、元処理は退避するだけで呼び出さない 処理ごと再定義 */
const _Window_BattleLog_displayActionResults_og = Window_BattleLog.prototype.displayActionResults;
Window_BattleLog.prototype.displayActionResults = function(subject, target) {
    if (target.result().used) {
        this.displayCriticalFlavor(subject, target);
        this.push("pushBaseLine");
        this.displayCritical(target);
        this.push("popupDamage", target);
        this.push("popupDamage", subject);
        this.displayDamage(target);
        this.displayAffectedStatus(target);
        this.displayFailure(target);
        this.push("waitForNewLine");
        this.push("popBaseLine");
    }
};

Window_BattleLog.prototype.displayCriticalFlavor = function(subject, target) {
    if (target.result().critical_flavor != "" && subject.isActor()){
        this.displayItemMessage(target.result().critical_flavor, subject, target.result().critical_flavor_item);
    } 
};

Window_BattleLog.prototype.displayItemUseMessage = function(fmt, subject, item) {
    if (fmt) {
        this.push("addText", fmt.format(subject.name(), item.iconIndex, item.name));
    }
};

const _Game_Action_applyCritical_excri_flavor = Game_Action.prototype.apply;
Game_Action.prototype.apply = function(target) {
    _Game_Action_applyCritical_excri_flavor.apply(this, arguments);
    const result = target.result();
    const subjectResult = this.subject().result();
    result.critical_flavor = "";
    result.critical_flavor_item = "";
    if (result.critical_lv >= 2) {
        result.critical_flavor = this.item().message2;
        result.critical_flavor_item = this.item();
    }
};


})();

